
GO
SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;


GO
:on error exit
GO
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END
GO

:setvar DatabaseName "RegistryQA"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "48"
:setvar DeployVersion "20150715.1"
:setvar DefaultFilePrefix "Registry"


:setvar DefaultDataPath "M:\SQLData\UserDB\Registry_AHOBPR\"
:setvar DefaultLogPath "L:\SQLLogs\"


GO

PRINT 'Step 1 - Registry.Database.PreDeploy.sql
Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)
BUILD $(DeployVersion)
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

 ';
GO

PRINT N'Creating FILEGROUP [AHOBPR]...';


GO
IF NOT EXISTS(SELECT * FROM sys.filegroups WHERE [NAME] = 'AHOBPR')
  ALTER DATABASE [$(DatabaseName)]
      ADD FILEGROUP [AHOBPR];


GO
IF NOT EXISTS(SELECT * FROM sys.database_files WHERE [NAME] = 'AHOBPR_1')
  ALTER DATABASE [$(DatabaseName)]
      ADD FILE (NAME = [AHOBPR_1], FILENAME = N'$(DefaultDataPath)$(DefaultFilePrefix)_AHOBPR_1.mdf',
      -- SIZE = 512KB , MAXSIZE = UNLIMITED, FILEGROWTH = 48KB) TO FILEGROUP [AHOBPR];  -- Test values
      SIZE = 512000KB , MAXSIZE = UNLIMITED, FILEGROWTH = 204800KB) TO FILEGROUP [AHOBPR];

GO

IF NOT EXISTS(SELECT * FROM sys.filegroups WHERE [NAME] = 'FILESTREAMGroup')
  ALTER DATABASE [$(DatabaseName)]
      ADD FILEGROUP [FILESTREAMGroup] CONTAINS FILESTREAM;
GO
    
IF NOT EXISTS(SELECT * FROM sys.database_files WHERE [NAME] = 'AHOBPR_FILESTREAM')
  ALTER DATABASE [$(DatabaseName)]
      ADD FILE (NAME = [AHOBPR_FILESTREAM], FILENAME = N'$(DefaultDataPath)AHOBPR_FILESTREAM_FOLDER') 
      TO FILEGROUP [FILESTREAMGroup];
       
GO

USE [$(DatabaseName)];
GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('$(MajorReleaseNumber)'
           ,'$(MinorReleaseNumber)'
           ,'$(PointReleaseNumber)'
           ,0
           ,'Step 1 - Registry.Database.PreDeploy.sql'
		       ,'Step 1 - Registry.Database.PreDeploy.sql Script'
           ,'AHOBPR'
           ,GETDATE());
GO
      


PRINT '';
PRINT 'Step 1 - Registry.Database.PreDeploy.sql Script Complete.';
PRINT '';
PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';
-----------------------
-- END OF PRE-DEPLOY --
-----------------------